#!/usr/bin/env python
# Hide rows if condition
# 041112 - first version of this script
# 041117 - only for "All Project" reports

def SetHide(self, columnname, showval):
    """
    column = column in data base (not column type)
    showval = only show columns with this value
    uses report row's table and table id to find column value
    """
    rid = self.ReportID  # current report
    if rid == 1: return  # don't perform hide/show on Main Window

    trep = Data.Database['Report']
    trow = Data.Database['ReportRow']

    change = { 'Table': 'ReportRow' }
    rlist = Data.GetRowList(rid)
    for row in rlist:
        rr = trow[row]
        # if debug: print "row", rr
        oldhide = rr.get('Hidden') == True  # do I need this to force True or False

        tn, tid = rr.get('TableName'), rr.get('TableID')
        if tn and tid:
            val = Data.Database[tn][tid].get(columnname)  # okay to ignore delete status??
            newhide = val != showval
            if newhide != oldhide:
                change['ID'] = row
                change['Hidden'] = newhide
                Data.Update(change)
        # if debug: print "old, new", oldhide, newhide

    Data.SetUndo("Hide If " + columnname + " Not " + str(showval))

# SetHide(self, 'Category', 'Issue')
SetHide(self, 'ProjectID', 1)
